--- A drawable 3D line
--- 
--- @class types.world_line_drawable
local world_line_drawable = {}

--- Adds a point to the line
--- @sig (x : number, y : number, z : number, opt_color : types.color): types.world_line_drawable
--- @param x number The x position
--- @param y number The y position
--- @param z number The z position
--- @param opt_color types.color (optional) The color for this point
function world_line_drawable.point(x, y, z, opt_color) end

--- Sets the default color for new points
--- @sig (color : types.color): types.world_line_drawable
--- @param color types.color The default color
function world_line_drawable.color(color) end

--- Inserts the drawable into a world canvas
--- @sig (canvas : types.world_canvas)
--- @param canvas types.world_canvas The world canvas to insert into
function world_line_drawable.insert(canvas) end

if not types then types = {} end
types.world_line_drawable = world_line_drawable
