--- A drawable 3D flat circle
--- 
--- @class types.world_flat_circle_drawable
local world_flat_circle_drawable = {}

--- Sets the center position
--- @sig (x : number, y : number, z : number): types.world_flat_circle_drawable
--- @param x number The x position
--- @param y number The y position
--- @param z number The z position
function world_flat_circle_drawable.center(x, y, z) end

--- Sets the radius
--- @sig (radius : number): types.world_flat_circle_drawable
--- @param radius number The radius
function world_flat_circle_drawable.radius(radius) end

--- Sets the number of segments
--- @sig (segments : number): types.world_flat_circle_drawable
--- @param segments number The number of segments
function world_flat_circle_drawable.segments(segments) end

--- Sets the fill color
--- @sig (color : types.color): types.world_flat_circle_drawable
--- @param color types.color The fill color
function world_flat_circle_drawable.fill_color(color) end

--- Sets the outline color
--- @sig (color : types.color): types.world_flat_circle_drawable
--- @param color types.color The outline color
function world_flat_circle_drawable.outline_color(color) end

--- Inserts the drawable into a world canvas
--- @sig (canvas : types.world_canvas)
--- @param canvas types.world_canvas The world canvas to insert into
function world_flat_circle_drawable.insert(canvas) end

if not types then types = {} end
types.world_flat_circle_drawable = world_flat_circle_drawable
