--- A drawable 3D box
--- 
--- @class types.world_box_drawable
local world_box_drawable = {}

--- Sets the minimum position
--- @sig (x : number, y : number, z : number): types.world_box_drawable
--- @param x number The x position
--- @param y number The y position
--- @param z number The z position
function world_box_drawable.min(x, y, z) end

--- Sets the maximum position
--- @sig (x : number, y : number, z : number): types.world_box_drawable
--- @param x number The x position
--- @param y number The y position
--- @param z number The z position
function world_box_drawable.max(x, y, z) end

--- Sets the fill color
--- @sig (color : types.color): types.world_box_drawable
--- @param color types.color The fill color
function world_box_drawable.fill_color(color) end

--- Sets the outline color
--- @sig (color : types.color): types.world_box_drawable
--- @param color types.color The outline color
function world_box_drawable.outline_color(color) end

--- Inserts the drawable into a world canvas
--- @sig (canvas : types.world_canvas)
--- @param canvas types.world_canvas The world canvas to insert into
function world_box_drawable.insert(canvas) end

if not types then types = {} end
types.world_box_drawable = world_box_drawable
