--- A 4D vector
--- 
--- @class types.vector4
--- @field x number
--- @field y number
--- @field z number
--- @field w number
local vector4 = {}

--- Creates a new 4D vector
--- @sig (opt_x : number, opt_y : number, opt_z : number, opt_w : number): types.vector4
--- @param opt_x number (optional) The x component
--- @param opt_y number (optional) The y component
--- @param opt_z number (optional) The z component
--- @param opt_w number (optional) The w component
--- @return types.vector4 A new vector instance
function vector4.new(opt_x, opt_y, opt_z, opt_w) end

--- The x component
--- @type number
vector4.x = nil

--- The y component
--- @type number
vector4.y = nil

--- The z component
--- @type number
vector4.z = nil

--- The w component
--- @type number
vector4.w = nil

--- Adds another vector to this one and returns a new vector
--- @sig (other : types.vector4): types.vector4
--- @param other types.vector4 The vector to add
--- @return types.vector4 A new vector instance
function vector4.add(other) end

--- Subtracts another vector from this one and returns a new vector
--- @sig (other : types.vector4): types.vector4
--- @param other types.vector4 The vector to subtract
--- @return types.vector4 A new vector instance
function vector4.sub(other) end

--- Multiplies this vector by another vector or a number and returns a new vector
--- @sig (other : types.vector4 | number): types.vector4
--- @param other types.vector4 | number The vector or number to multiply by
--- @return types.vector4 A new vector instance
function vector4.mul(other) end

--- Divides this vector by another vector or a number and returns a new vector
--- @sig (other : types.vector4 | number): types.vector4
--- @param other types.vector4 | number The vector or number to divide by
--- @return types.vector4 A new vector instance
function vector4.div(other) end

--- Returns the distance between this vector and another
--- @sig (other : types.vector4): number
--- @param other types.vector4 The other vector
--- @return number The distance
function vector4.dist(other) end

--- Returns the length of this vector
--- @sig (): number
--- @return number The length
function vector4.length() end

--- Returns the dot product of this vector and another
--- @sig (other : types.vector4): number
--- @param other types.vector4 The other vector
--- @return number The dot product
function vector4.dot(other) end

--- Returns a normalized (unit length) version of this vector
--- @sig (): types.vector4
--- @return types.vector4 A new normalized vector instance
function vector4.normalize() end

if not types then types = {} end
types.vector4 = vector4
