--- A 3D vector
--- 
--- @class types.vector3
--- @field x number
--- @field y number
--- @field z number
local vector3 = {}

--- Creates a new 3D vector
--- @sig (opt_x : number, opt_y : number, opt_z : number): types.vector3
--- @param opt_x number (optional) The x component
--- @param opt_y number (optional) The y component
--- @param opt_z number (optional) The z component
--- @return types.vector3 A new vector instance
function vector3.new(opt_x, opt_y, opt_z) end

--- The x component
--- @type number
vector3.x = nil

--- The y component
--- @type number
vector3.y = nil

--- The z component
--- @type number
vector3.z = nil

--- Adds another vector to this one and returns a new vector
--- @sig (other : types.vector3): types.vector3
--- @param other types.vector3 The vector to add
--- @return types.vector3 A new vector instance
function vector3.add(other) end

--- Subtracts another vector from this one and returns a new vector
--- @sig (other : types.vector3): types.vector3
--- @param other types.vector3 The vector to subtract
--- @return types.vector3 A new vector instance
function vector3.sub(other) end

--- Multiplies this vector by another vector or a number and returns a new vector
--- @sig (other : types.vector3 | number): types.vector3
--- @param other types.vector3 | number The vector or number to multiply by
--- @return types.vector3 A new vector instance
function vector3.mul(other) end

--- Divides this vector by another vector or a number and returns a new vector
--- @sig (other : types.vector3 | number): types.vector3
--- @param other types.vector3 | number The vector or number to divide by
--- @return types.vector3 A new vector instance
function vector3.div(other) end

--- Returns the distance between this vector and another
--- @sig (other : types.vector3): number
--- @param other types.vector3 The other vector
--- @return number The distance
function vector3.dist(other) end

--- Returns the length of this vector
--- @sig (): number
--- @return number The length
function vector3.length() end

--- Returns the dot product of this vector and another
--- @sig (other : types.vector3): number
--- @param other types.vector3 The other vector
--- @return number The dot product
function vector3.dot(other) end

--- Returns a normalized (unit length) version of this vector
--- @sig (): types.vector3
--- @return types.vector3 A new normalized vector instance
function vector3.normalize() end

if not types then types = {} end
types.vector3 = vector3
