--- A 2D vector
--- 
--- @class types.vector2
--- @field x number
--- @field y number
local vector2 = {}

--- Creates a new 2D vector
--- @sig (opt_x : number, opt_y : number): types.vector2
--- @param opt_x number (optional) The x component
--- @param opt_y number (optional) The y component
--- @return types.vector2 A new vector instance
function vector2.new(opt_x, opt_y) end

--- The x component
--- @type number
vector2.x = nil

--- The y component
--- @type number
vector2.y = nil

--- Adds another vector to this one and returns a new vector
--- @sig (other : types.vector2): types.vector2
--- @param other types.vector2 The vector to add
--- @return types.vector2 A new vector instance
function vector2.add(other) end

--- Subtracts another vector from this one and returns a new vector
--- @sig (other : types.vector2): types.vector2
--- @param other types.vector2 The vector to subtract
--- @return types.vector2 A new vector instance
function vector2.sub(other) end

--- Multiplies this vector by another vector or a number and returns a new vector
--- @sig (other : types.vector2 | number): types.vector2
--- @param other types.vector2 | number The vector or number to multiply by
--- @return types.vector2 A new vector instance
function vector2.mul(other) end

--- Divides this vector by another vector or a number and returns a new vector
--- @sig (other : types.vector2 | number): types.vector2
--- @param other types.vector2 | number The vector or number to divide by
--- @return types.vector2 A new vector instance
function vector2.div(other) end

--- Returns the distance between this vector and another
--- @sig (other : types.vector2): number
--- @param other types.vector2 The other vector
--- @return number The distance
function vector2.dist(other) end

--- Returns the length of this vector
--- @sig (): number
--- @return number The length
function vector2.length() end

--- Returns the dot product of this vector and another
--- @sig (other : types.vector2): number
--- @param other types.vector2 The other vector
--- @return number The dot product
function vector2.dot(other) end

--- Returns a normalized (unit length) version of this vector
--- @sig (): types.vector2
--- @return types.vector2 A new normalized vector instance
function vector2.normalize() end

if not types then types = {} end
types.vector2 = vector2
