--- A drawable triangle
--- 
--- @class types.triangle_drawable
local triangle_drawable = {}

--- Creates a new triangle drawable
--- @sig (): types.triangle_drawable
--- @return types.triangle_drawable A new triangle drawable instance
function triangle_drawable.new() end

--- Sets the position
--- @sig (x : number, y : number): types.triangle_drawable
--- @param x number The x position
--- @param y number The y position
--- @return types.triangle_drawable The triangle drawable instance
function triangle_drawable.position(x, y) end

--- Sets the bounds
--- @sig (width : number, height : number): types.triangle_drawable
--- @param width number The width
--- @param height number The height
--- @return types.triangle_drawable The triangle drawable instance
function triangle_drawable.bounds(width, height) end

--- Sets the base color
--- @sig (color : types.color): types.triangle_drawable
--- @param color types.color The base color
--- @return types.triangle_drawable The triangle drawable instance
function triangle_drawable.base_color(color) end

--- Sets the gradient color
--- @sig (color : types.color): types.triangle_drawable
--- @param color types.color The gradient color
--- @return types.triangle_drawable The triangle drawable instance
function triangle_drawable.grad_color(color) end

--- Sets the gradient mode
--- @sig (mode : enums.gradient_mode): types.triangle_drawable
--- @param mode enums.gradient_mode The gradient mode
--- @return types.triangle_drawable The triangle drawable instance
function triangle_drawable.gradient_mode(mode) end

--- Sets the outline
--- @sig (thickness : number, color : types.color): types.triangle_drawable
--- @param thickness number The outline thickness
--- @param color types.color The outline color
--- @return types.triangle_drawable The triangle drawable instance
function triangle_drawable.outline(thickness, color) end

--- Inserts the drawable into a canvas
--- @sig (canvas : types.ui_canvas)
--- @param canvas types.ui_canvas The canvas to insert into
function triangle_drawable.insert(canvas) end

if not types then types = {} end
types.triangle_drawable = triangle_drawable
