--- A texture that can be used in drawables
--- 
--- > [!NOTE]
--- > To save GPU memory, textures automatically expire and are deallocated if they are not used for more than **5 minutes**.
--- > Expired textures are automatically re-created (and re-downloaded if necessary) the next time they are accessed by a drawable.
--- 
--- @class types.texture
local texture = {}

--- Downloads a texture from a URL
--- > **⚠️ WARNING:** This API requires the `--- @unsafe true` metadata.
--- 
--- @sig (url : string): types.texture
--- @param url string The URL of the texture
--- @return types.texture The texture instance (returns a placeholder until downloaded)
function texture.from_url(url) end

--- Creates a texture from a Java BufferedImage
--- @sig (image : userdata, opt_key : string | number): types.texture
--- @param image userdata The java.awt.image.BufferedImage instance
--- @param opt_key string|number (optional) A unique key to identify this image for caching
--- @return types.texture The texture instance
function texture.from_image(image, opt_key) end

if not types then types = {} end
types.texture = texture
