--- A drawable text
--- 
--- @class types.text_drawable
local text_drawable = {}

--- Creates a new text drawable
--- @sig (): types.text_drawable
--- @return types.text_drawable A new text drawable instance
function text_drawable.new() end

--- Sets the text
--- @sig (text : string): types.text_drawable
--- @param text string The text to draw
--- @return types.text_drawable The text drawable instance
function text_drawable.text(text) end

--- Sets the alignment
--- @sig (align : enums.align): types.text_drawable
--- @param align enums.align The alignment
--- @return types.text_drawable The text drawable instance
function text_drawable.align(align) end

--- Sets the position
--- @sig (x : number, y : number): types.text_drawable
--- @param x number The x position
--- @param y number The y position
--- @return types.text_drawable The text drawable instance
function text_drawable.position(x, y) end

--- Sets the scale
--- @sig (scale : number): types.text_drawable
--- @param scale number The scale
--- @return types.text_drawable The text drawable instance
function text_drawable.scale(scale) end

--- Returns the width of the text
--- @sig (): number
--- @return number The width
function text_drawable.width() end

--- Returns the height of the text
--- @sig (): number
--- @return number The height
function text_drawable.height() end

--- Sets the base color
--- @sig (color : types.color): types.text_drawable
--- @param color types.color The base color
--- @return types.text_drawable The text drawable instance
function text_drawable.base_color(color) end

--- Sets the gradient color
--- @sig (color : types.color): types.text_drawable
--- @param color types.color The gradient color
--- @return types.text_drawable The text drawable instance
function text_drawable.grad_color(color) end

--- Enables shadow
--- @sig (): types.text_drawable
--- @return types.text_drawable The text drawable instance
function text_drawable.shadow() end

--- Sets the outline
--- @sig (thickness : number, color : types.color): types.text_drawable
--- @param thickness number The outline thickness
--- @param color types.color The outline color
--- @return types.text_drawable The text drawable instance
function text_drawable.outline(thickness, color) end

--- Sets the font face
--- @sig (font : enums.font_face): types.text_drawable
--- @param font enums.font_face The font face
--- @return types.text_drawable The text drawable instance
function text_drawable.font_face(font) end

--- Inserts the drawable into a canvas
--- @sig (canvas : types.ui_canvas)
--- @param canvas types.ui_canvas The canvas to insert into
function text_drawable.insert(canvas) end

if not types then types = {} end
types.text_drawable = text_drawable
