--- A drawable rectangle
--- 
--- @class types.rect_drawable
local rect_drawable = {}

--- Creates a new rect drawable
--- @sig (): types.rect_drawable
--- @return types.rect_drawable A new rect drawable instance
function rect_drawable.new() end

--- Sets the position
--- @sig (x : number, y : number): types.rect_drawable
--- @param x number The x position
--- @param y number The y position
--- @return types.rect_drawable The rect drawable instance
function rect_drawable.position(x, y) end

--- Sets the bounds
--- @sig (width : number, height : number): types.rect_drawable
--- @param width number The width
--- @param height number The height
--- @return types.rect_drawable The rect drawable instance
function rect_drawable.bounds(width, height) end

--- Sets the base color
--- @sig (color : types.color): types.rect_drawable
--- @param color types.color The base color
--- @return types.rect_drawable The rect drawable instance
function rect_drawable.base_color(color) end

--- Sets the gradient color
--- @sig (color : types.color): types.rect_drawable
--- @param color types.color The gradient color
--- @return types.rect_drawable The rect drawable instance
function rect_drawable.grad_color(color) end

--- Sets the gradient mode
--- @sig (mode : enums.gradient_mode): types.rect_drawable
--- @param mode enums.gradient_mode The gradient mode
--- @return types.rect_drawable The rect drawable instance
function rect_drawable.gradient_mode(mode) end

--- Sets the corner radii
--- @sig (all : number): types.rect_drawable
--- @sig (tl : number, tr : number, bl : number, br : number): types.rect_drawable
--- @param all number The radius for all corners (when using 1 argument)
--- @param tl number The top-left radius (when using 4 arguments)
--- @param tr number The top-right radius (when using 4 arguments)
--- @param bl number The bottom-left radius (when using 4 arguments)
--- @param br number The bottom-right radius (when using 4 arguments)
--- @return types.rect_drawable The rect drawable instance
function rect_drawable.corner_radii(all, tl, tr, bl, br) end

--- Sets the outline
--- @sig (thickness : number, color : types.color): types.rect_drawable
--- @param thickness number The outline thickness
--- @param color types.color The outline color
--- @return types.rect_drawable The rect drawable instance
function rect_drawable.outline(thickness, color) end

--- Sets the texture
--- @sig (texture : types.texture): types.rect_drawable
--- @param texture types.texture The texture instance
--- @return types.rect_drawable The rect drawable instance
function rect_drawable.texture(texture) end

--- Sets the blur
--- @sig (opacity : number): types.rect_drawable
--- @param opacity number The blur opacity (0.0 to 1.0)
--- @return types.rect_drawable The rect drawable instance
function rect_drawable.blur(opacity) end

--- Inserts the drawable into a canvas
--- @sig (canvas : types.ui_canvas)
--- @param canvas types.ui_canvas The canvas to insert into
function rect_drawable.insert(canvas) end

if not types then types = {} end
types.rect_drawable = rect_drawable
