--- Called when the player sends an update packet
--- 
--- @class types.player_send_update_event
--- @field x number
--- @field y number
--- @field z number
--- @field yaw number
--- @field pitch number
--- @field on_ground boolean
--- @field type string
local player_send_update_event = {}

--- The x position
--- @type number
player_send_update_event.x = nil

--- The y position
--- @type number
player_send_update_event.y = nil

--- The z position
--- @type number
player_send_update_event.z = nil

--- The yaw rotation
--- @type number
player_send_update_event.yaw = nil

--- The pitch rotation
--- @type number
player_send_update_event.pitch = nil

--- Whether the player is on the ground
--- @type boolean
player_send_update_event.on_ground = nil

--- The update type ("pre" or "post")
--- @type string
player_send_update_event.type = nil

if not types then types = {} end
types.player_send_update_event = player_send_update_event
