--- A registered feature
--- 
--- @class types.feature
local feature = {}

--- Registers an event handler
--- @sig (name : string, handler : function)
--- @param name string The name of the event to listen to
--- @param handler function The event handler function
--- * A list of supported events can be found in [Events](/events)
function feature.on(name, handler) end

--- Registers a boolean property
--- @sig (name : string, value : bool, opt_visibility : function): types.boolean_property
--- @param name string The name of the boolean property
--- @param value bool The default boolean value
--- @param opt_visibility function The optional setting gui visibility
--- @return types.boolean_property The registered boolean property
--- ```lua
--- local property = feature.register_boolean("Hello Test", false, function() return true end)
--- local property = feature.register_boolean("Hello Test", false)
--- ```
function feature.register_boolean(name, value, opt_visibility) end

--- Registers a string property
--- @sig (name : string, value : string, opt_visibility : function): types.string_property
--- @param name string The name of the string property
--- @param value string The default string value
--- @param opt_visibility function The optional setting gui visibility
--- @return types.string_property The registered string property
--- ```lua
--- local property = feature.register_string("Hello Test", "Hello World", function() return true end)
--- local property = feature.register_string("Hello Test", "Hello World")
--- ```
function feature.register_string(name, value, opt_visibility) end

--- Registers a number property
--- @sig (name : number, value : number, opt_visibility : function): types.number_property
--- @param name number The name of the number property
--- @param min number The minimum number value
--- @param max number The maximum number value
--- @param step number The step number value
--- @param value number The default number value
--- @param opt_visibility function The optional setting gui visibility
--- @return types.number_property The registered number property
--- ```lua
--- local property = feature.register_number("Hello Test", 0, 10, 1, 5, function() return true end)
--- local property = feature.register_number("Hello Test", 0, 10, 0.1, 5)
--- ```
function feature.register_number(name, min, max, step, value, opt_visibility) end

--- Registers a color property
--- @sig (name : string, value : types.color, opt_visibility : function): types.color_property
--- @param name string The name of the color property
--- @param value types.color The default types.color value
--- @param opt_visibility function The optional setting gui visibility
--- @return types.color_property The registered color property
--- ```lua
--- local property = feature.register_color("Hello Test", types.color.white, function() return true end)
--- local property = feature.register_color("Hello Test", types.color.new(255, 0, 255))
--- ```
function feature.register_color(name, value, opt_visibility) end

if not types then types = {} end
types.feature = feature
