--- A wrapper class for interacting with colors
--- 
--- @class types.color
--- @field WHITE color
--- @field BLACK color
--- @field RED color
--- @field GREEN color
--- @field BLUE color
--- @field YELLOW color
--- @field CYAN color
--- @field MAGENTA color
--- @field GRAY color
--- @field ORANGE color
--- @field TRANSPARENT color
--- @field red number
--- @field green number
--- @field blue number
--- @field alpha number
local color = {}

--- The white color (woah!!)
--- @type color
color.WHITE = nil

--- The black color (woah!!)
--- @type color
color.BLACK = nil

--- The red color (woah!!)
--- @type color
color.RED = nil

--- The green color (woah!!)
--- @type color
color.GREEN = nil

--- The blue color (woah!!)
--- @type color
color.BLUE = nil

--- The yellow color (woah!!)
--- @type color
color.YELLOW = nil

--- The cyan color (woah!!)
--- @type color
color.CYAN = nil

--- The magenta color (woah!!)
--- @type color
color.MAGENTA = nil

--- The gray color (woah!!)
--- @type color
color.GRAY = nil

--- The orange color (woah!!)
--- @type color
color.ORANGE = nil

--- The transparent color (woah!!)
--- @type color
color.TRANSPARENT = nil

--- Creates a new color instance
--- @sig (red : number, green : number, blue : number, opt_alpha : number): types.color
--- @param red number The red color channel
--- @param green number The green color channel
--- @param blue number The blue color channel
--- @param opt_alpha number (optional) The alpha color channel
--- @return types.color A new color instance
function color.new(red, green, blue, opt_alpha) end

--- Sets the color's alpha and returns it
--- @sig (alpha : number): types.color
--- @param alpha number The alpha from 0 to 255
--- @return types.color
function color.with_alpha(alpha) end

--- The red color channel
--- @type number
color.red = nil

--- The green color channel
--- @type number
color.green = nil

--- The blue color channel
--- @type number
color.blue = nil

--- The alpha color channel
--- @type number
color.alpha = nil

if not types then types = {} end
types.color = color
