--- Called when updating the player rotation
--- 
--- @class types.client_rotation_event
--- @field rotation types.vector2
--- @field tick_delta number
local client_rotation_event = {}

--- The current rotations (x: yaw, y: pitch)
--- @type types.vector2
client_rotation_event.rotation = nil

--- The tick delta
--- @type number
client_rotation_event.tick_delta = nil

--- Sets the new rotation, rotations will automatically be corrected (GCD applied, properly clamped & wrapped)
--- @sig (yaw : number, pitch : number)
--- @param yaw number The new yaw
--- @param pitch number The new pitch
function client_rotation_event.set_rotation(yaw, pitch) end

if not types then types = {} end
types.client_rotation_event = client_rotation_event
