--- A drawable circle
--- 
--- @class types.circle_drawable
local circle_drawable = {}

--- Creates a new circle drawable
--- @sig (): types.circle_drawable
--- @return types.circle_drawable A new circle drawable instance
function circle_drawable.new() end

--- Sets the position
--- @sig (x : number, y : number): types.circle_drawable
--- @param x number The x position
--- @param y number The y position
--- @return types.circle_drawable The circle drawable instance
function circle_drawable.position(x, y) end

--- Sets the size
--- @sig (size : number): types.circle_drawable
--- @param size number The size
--- @return types.circle_drawable The circle drawable instance
function circle_drawable.size(size) end

--- Sets the progress
--- @sig (progress : number): types.circle_drawable
--- @param progress number The progress (0.0 to 1.0)
--- @return types.circle_drawable The circle drawable instance
function circle_drawable.progress(progress) end

--- Sets the base color
--- @sig (color : types.color): types.circle_drawable
--- @param color types.color The base color
--- @return types.circle_drawable The circle drawable instance
function circle_drawable.base_color(color) end

--- Sets the gradient color
--- @sig (color : types.color): types.circle_drawable
--- @param color types.color The gradient color
--- @return types.circle_drawable The circle drawable instance
function circle_drawable.grad_color(color) end

--- Sets the outline
--- @sig (thickness : number, color : types.color): types.circle_drawable
--- @param thickness number The outline thickness
--- @param color types.color The outline color
--- @return types.circle_drawable The circle drawable instance
function circle_drawable.outline(thickness, color) end

--- Sets the texture
--- @sig (texture : types.texture): types.circle_drawable
--- @param texture types.texture The texture instance
--- @return types.circle_drawable The circle drawable instance
function circle_drawable.texture(texture) end

--- Sets the blur
--- @sig (opacity : number): types.circle_drawable
--- @param opacity number The blur opacity (0.0 to 1.0)
--- @return types.circle_drawable The circle drawable instance
function circle_drawable.blur(opacity) end

--- Inserts the drawable into a canvas
--- @sig (canvas : types.ui_canvas)
--- @param canvas types.ui_canvas The canvas to insert into
function circle_drawable.insert(canvas) end

if not types then types = {} end
types.circle_drawable = circle_drawable
