--- Utilities for interacting with network packets
--- 
--- @class network
local network = {}

--- Sends a packet through the normal channel, triggering events
--- @sig (packet : userdata)
--- @param packet object The raw Java packet to send
function network.send(packet) end

--- Sends a packet directly, bypassing the event system
--- @sig (packet : userdata)
--- @param packet object The raw Java packet to send
function network.send_no_event(packet) end

--- Checks if a packet is a server-to-client packet (Clientbound)
--- @sig (packet : userdata): boolean
--- @param packet object The raw Java packet to check
--- @return boolean True if it's a server packet
function network.is_server_packet(packet) end

--- Processes a packet as if it was received from the server
--- @sig (packet : userdata)
--- @param packet object The raw Java packet to process
function network.process_packet(packet) end

_G.network = network
