--- Utilities to interact with Neon
--- 
--- @class neon
local neon = {}

--- Returns the current Neon username
--- @sig (): string
--- @return string
function neon.username() end

--- Returns the current Neon version
--- @sig (): string
--- @return string
function neon.version() end

--- Registers a feature in the client
--- @sig (name : string, desc : string): types.feature
--- @param name string The name of the feature
--- @param desc string The description of the feature
--- @return types.feature The registered feature
function neon.register_feature(name, desc) end

--- Registers a command in the client
--- @sig (name : string, desc : string, opt_aliases : table, opt_args : table, opt_executor : function)
--- @param name string The name of the command
--- @param desc string The description of the command
--- @param opt_aliases table (optional) The aliases for the command
--- @param opt_args table (optional) The arguments for the command
--- @param opt_executor function (optional) The command executor function
function neon.register_command(name, desc, opt_aliases, opt_args, opt_executor) end

--- Returns whether a feature is enabled or not
--- @sig (name : string): bool
--- @param name string The name of the feature
--- @return bool The feature state
function neon.is_feature_enabled(name) end

--- Toggles a feature
--- @sig (name : string)
--- @param name string The name of the feature
function neon.toggle_feature(name) end

--- Returns all feature names as a list of strings
--- @sig (): table
--- @return table The feature names
function neon.features_list() end

--- Executes a chat command
--- @sig (cmd : string)
--- @param cmd string The full command string
function neon.execute_command(cmd) end

--- Gets the current killaura target
--- @sig (): userdata
--- @return userdata (Minecraft's Java LivingEntity object)
function neon.killaura_target() end

--- Gets the first color gradient of the currently set theme
--- @sig (): types.color
--- @return types.color The gradient color
function neon.first_theme_color() end

--- Gets the second color gradient of the currently set theme
--- @sig (): types.color
--- @return types.color The gradient color
function neon.second_theme_color() end

_G.neon = neon
