--- Utilities to perform HTTP requests
--- > **⚠️ WARNING:** This API requires the `--- @unsafe true` metadata.
--- 
--- @class http
local http = {}

--- Performs a GET request
--- @sig (url : string, opt_headers : table): table
--- @param url string The URL to request
--- @param opt_headers table (optional) Request headers
--- @return table The response table:
--- 
--- | Key | type | Description |
--- | --- | --- | --- |
--- | `status` | number | The HTTP status code |
--- | `body` | string | The raw response body |
--- | `headers` | table | A table of response headers |
function http.get(url, opt_headers) end

--- Performs a POST request
--- @sig (url : string, body : string, opt_headers : table): table
--- @param url string The URL to request
--- @param body string The request body
--- @param opt_headers table (optional) Request headers
--- @return table The response table:
--- 
--- | Key | type | Description |
--- | --- | --- | --- |
--- | `status` | number | The HTTP status code |
--- | `body` | string | The raw response body |
--- | `headers` | table | A table of response headers |
function http.post(url, body, opt_headers) end

_G.http = http
