--- Game client utilities
--- 
--- @class client
--- @field game_speed number
local client = {}

--- Returns the player name
--- @sig (): string
--- @return string
function client.player_name() end

--- Returns the client FPS
--- @sig (): number
--- @return number
function client.fps() end

--- Returns the current time in milliseconds
--- @sig (): number
--- @return number
function client.time_millis() end

--- Returns the window width
--- @sig (): number
--- @return number
function client.window_width() end

--- Returns the window height
--- @sig (): number
--- @return number
function client.window_height() end

--- Returns the scaled window width
--- @sig (): number
--- @return number
function client.scaled_window_width() end

--- Returns the scaled window height
--- @sig (): number
--- @return number
function client.scaled_window_height() end

--- Returns the gui scale
--- @sig (): number
--- @return number
function client.gui_scale() end

--- Returns the currently connected server's ip address
--- @sig (): string
--- @return string
function client.connected_server() end

--- Plays a sound using Minecraft's sound identifiers
--- @sig (id : string, pitch : number, volume : number)
--- @param id string The sound id
--- @param pitch number The sound pitch
--- @param volume number The sound volume
--- * A list of Sound ID's can be found on [this website](https://www.digminecraft.com/lists/sound_list_pc.php)
function client.play_sound(id, pitch, volume) end

--- Returns whether a keyboard key is down or not
--- @sig (key : enums.key_code): bool
--- @param key enums.key_code The key to check
--- @return bool
function client.is_key_down(key) end

--- Returns whether a mouse button is down or not
--- @sig (button : number): bool
--- @param button number The mouse button to check
--- @return bool
function client.is_mouse_button_down(button) end

--- Controls the game timer speed
--- @type number
client.game_speed = nil

_G.client = client
